﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_E
{
    public partial class Form1 : Form
    {
        double[,] podaci = new double[19864, 2];
        public Form1()
        {
            InitializeComponent();

            try
            {
                StreamReader reader = new StreamReader("podaciE.txt");
                int trenutniRedak = 0;

                while (!reader.EndOfStream)
                {
                    string[] dijeloviLinije = reader.ReadLine().Split(';');

                    podaci[trenutniRedak, 0] = Convert.ToDouble(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToDouble(dijeloviLinije[1]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }

        private void btnDohvati_Click(object sender, EventArgs e)
        {
            int indeks = Convert.ToInt32(txtIndeks.Text);

            if (indeks >= 0 && indeks < podaci.GetLength(0))
            {
                txtXCord.Text = Convert.ToString(podaci[indeks, 0]);
                txtYCord.Text = Convert.ToString(podaci[indeks, 1]);
            }
            else
            {
                MessageBox.Show("Unijeli ste neispravan indeks: " + indeks + "!");
            }
        }

        static double udaljenost(double x1, double y1, double x2, double y2)
        {
            double d = Math.Sqrt(Math.Pow(x1 - x2, 2) + Math.Pow(y1 - y2, 2)) * 111.32;

            return d;
        }
        private void btnIzracunajMaxUdaljenost_Click(object sender, EventArgs e)
        {
            int indeksPrve = 0;
            int indeksDruge = 0;
            double najvecaUdaljenost = double.MinValue;
            double trenutnaUdaljenost = 0.0;

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                for (int j = 0; j < podaci.GetLength(0); j++)
                {
                    trenutnaUdaljenost = udaljenost(podaci[i, 0], podaci[i, 1], podaci[j, 0], podaci[j, 1]);

                    if (trenutnaUdaljenost > najvecaUdaljenost)
                    {
                        najvecaUdaljenost = trenutnaUdaljenost;
                        indeksPrve = i;
                        indeksDruge = j;
                    }
                }
            }

            txtIMax.Text = Convert.ToString(indeksPrve);
            txtJMax.Text = Convert.ToString(indeksDruge);
            txtMaxUdalj.Text = najvecaUdaljenost + " km";
        }

        private void btnIzracunajUdalj_Click(object sender, EventArgs e)
        {
            double x1 = Convert.ToDouble(txtX1.Text);
            double y1 = Convert.ToDouble(txtY1.Text);
            double x2 = Convert.ToDouble(txtX2.Text);
            double y2 = Convert.ToDouble(txtY2.Text);

            double d = udaljenost(x1, y1, x2, y2);

            txtUdaljenost.Text = d + " km";
        }
    }
}